package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Frequency implements Serializable {

    public enum Unit {
        DAY,
        WEEK,
        MONTH,
        YEAR
    }

    @JsonProperty("every")
    private Integer every;

    @JsonProperty("unit")
    private Unit unit;


    public Integer getEvery() {
        return every;
    }

    public void setEvery(Integer every) {
        this.every = every;
    }

    public Unit getUnit() {
        return unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public String toString() {
        return "Frequency [" +
                ((every != null) ? "every=" + every + ", " : "") +
                ((unit != null) ? "unit=" + unit + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Frequency frequency = (Frequency) o;
        return Objects.equals(every, frequency.every) && unit == frequency.unit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(every, unit);
    }
}