package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SubMerchantData implements Serializable {

    @JsonProperty("mcc")
    private String mcc;

    @JsonProperty("document")
    private Document document;


    public String getMcc() {
        return mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public Document getDocument() {
        return document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public String toString() {
        return "SubMerchantData [" +
                ((mcc != null) ? "mcc='" + mcc + "', " : "") +
                ((document != null) ? "document=" + document + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubMerchantData that = (SubMerchantData) o;
        return Objects.equals(mcc, that.mcc) && Objects.equals(document, that.document);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mcc, document);
    }
}
