package ar.com.sdd.fiservapi.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Processor implements Serializable {

    @JsonProperty("responseCode")
    private String responseCode;

    @JsonProperty("responseMessage")
    private String responseMessage;

    @JsonProperty("authorizationCode")
    private String authorizationCode;


    public String getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getAuthorizationCode() {
        return authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @Override
    public String toString() {
        return "Processor [" +
                ((responseCode != null) ? "responseCode='" + responseCode + "', " : "") +
                ((responseMessage != null) ? "responseMessage='" + responseMessage + "', " : "") +
                ((authorizationCode != null) ? "authorizationCode='" + authorizationCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Processor processor = (Processor) o;
        return Objects.equals(responseCode, processor.responseCode) && Objects.equals(responseMessage, processor.responseMessage) && Objects.equals(authorizationCode, processor.authorizationCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(responseCode, responseMessage, authorizationCode);
    }
}
