package ar.com.sdd.fiservapi.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RequiredActions implements Serializable {

    @JsonProperty("requiredRedirectionData")
    private RequiredRedirectionData requiredRedirectionData;

    @JsonProperty("requiredConsumerData")
    private List<RequiredConsumerData> requiredConsumerData;

    @JsonProperty("requiredIntegrationData")
    private List<RequiredIntegrationData> requiredIntegrationData;


    public RequiredRedirectionData getRequiredRedirectionData() {
        return requiredRedirectionData;
    }

    public void setRequiredRedirectionData(RequiredRedirectionData requiredRedirectionData) {
        this.requiredRedirectionData = requiredRedirectionData;
    }

    public List<RequiredConsumerData> getRequiredConsumerData() {
        return requiredConsumerData;
    }

    public void setRequiredConsumerData(List<RequiredConsumerData> requiredConsumerData) {
        this.requiredConsumerData = requiredConsumerData;
    }

    public List<RequiredIntegrationData> getRequiredIntegrationData() {
        return requiredIntegrationData;
    }

    public void setRequiredIntegrationData(List<RequiredIntegrationData> requiredIntegrationData) {
        this.requiredIntegrationData = requiredIntegrationData;
    }

    @Override
    public String toString() {
        return "RequiredActions [" +
                ((requiredRedirectionData != null) ? "requiredRedirectionData=" + requiredRedirectionData + ", " : "") +
                ((requiredConsumerData != null) ? "requiredConsumerData=" + Arrays.toString(requiredConsumerData.toArray()) + ", " : "") +
                ((requiredIntegrationData != null) ? "requiredIntegrationData=" + Arrays.toString(requiredIntegrationData.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RequiredActions that = (RequiredActions) o;
        return Objects.equals(requiredRedirectionData, that.requiredRedirectionData) && Objects.equals(requiredConsumerData, that.requiredConsumerData) && Objects.equals(requiredIntegrationData, that.requiredIntegrationData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requiredRedirectionData, requiredConsumerData, requiredIntegrationData);
    }
}
