package ar.com.sdd.fiservapi.model.response.tokenization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AvsResponse implements Serializable {

    @JsonProperty("streetMatch")
    private String streetMatch;

    @JsonProperty("postalCodeMatch")
    private String postalCodeMatch;

    @JsonProperty("associationAvsResponse")
    private String associationAvsResponse;


    public String getStreetMatch() {
        return streetMatch;
    }

    public void setStreetMatch(String streetMatch) {
        this.streetMatch = streetMatch;
    }

    public String getPostalCodeMatch() {
        return postalCodeMatch;
    }

    public void setPostalCodeMatch(String postalCodeMatch) {
        this.postalCodeMatch = postalCodeMatch;
    }

    public String getAssociationAvsResponse() {
        return associationAvsResponse;
    }

    public void setAssociationAvsResponse(String associationAvsResponse) {
        this.associationAvsResponse = associationAvsResponse;
    }

    @Override
    public String toString() {
        return "AvsResponse [" +
                ((streetMatch != null) ? "streetMatch='" + streetMatch + "', " : "") +
                ((postalCodeMatch != null) ? "postalCodeMatch='" + postalCodeMatch + "', " : "") +
                ((associationAvsResponse != null) ? "associationAvsResponse='" + associationAvsResponse + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AvsResponse that = (AvsResponse) o;
        return Objects.equals(streetMatch, that.streetMatch) && Objects.equals(postalCodeMatch, that.postalCodeMatch) && Objects.equals(associationAvsResponse, that.associationAvsResponse);
    }

    @Override
    public int hashCode() {
        return Objects.hash(streetMatch, postalCodeMatch, associationAvsResponse);
    }
}
