package ar.com.sdd.fiservapi.model.response.tokenization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Processor implements Serializable {

    @JsonProperty("referenceNumber")
    private String referenceNumber;

    @JsonProperty("authorizationCode")
    private String authorizationCode;

    @JsonProperty("responseCode")
    private String responseCode;

    @JsonProperty("network")
    private String network;

    @JsonProperty("associationResponseCode")
    private String associationResponseCode;

    @JsonProperty("responseMessage")
    private String responseMessage;

    @JsonProperty("avsResponse")
    private AvsResponse avsResponse;

    @JsonProperty("securityCodeResponse")
    private String securityCodeResponse;


    public String getReferenceNumber() {
        return referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getAuthorizationCode() {
        return authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getNetwork() {
        return network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getAssociationResponseCode() {
        return associationResponseCode;
    }

    public void setAssociationResponseCode(String associationResponseCode) {
        this.associationResponseCode = associationResponseCode;
    }

    public String getResponseMessage() {
        return responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public AvsResponse getAvsResponse() {
        return avsResponse;
    }

    public void setAvsResponse(AvsResponse avsResponse) {
        this.avsResponse = avsResponse;
    }

    public String getSecurityCodeResponse() {
        return securityCodeResponse;
    }

    public void setSecurityCodeResponse(String securityCodeResponse) {
        this.securityCodeResponse = securityCodeResponse;
    }

    @Override
    public String toString() {
        return "Processor [" +
                ((referenceNumber != null) ? "referenceNumber='" + referenceNumber + "', " : "") +
                ((authorizationCode != null) ? "authorizationCode='" + authorizationCode + "', " : "") +
                ((responseCode != null) ? "responseCode='" + responseCode + "', " : "") +
                ((network != null) ? "network='" + network + "', " : "") +
                ((associationResponseCode != null) ? "associationResponseCode='" + associationResponseCode + "', " : "") +
                ((responseMessage != null) ? "responseMessage='" + responseMessage + "', " : "") +
                ((avsResponse != null) ? "avsResponse=" + avsResponse + ", " : "") +
                ((securityCodeResponse != null) ? "securityCodeResponse='" + securityCodeResponse + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Processor processor = (Processor) o;
        return Objects.equals(referenceNumber, processor.referenceNumber) && Objects.equals(authorizationCode, processor.authorizationCode) && Objects.equals(responseCode, processor.responseCode) && Objects.equals(network, processor.network) && Objects.equals(associationResponseCode, processor.associationResponseCode) && Objects.equals(responseMessage, processor.responseMessage) && Objects.equals(avsResponse, processor.avsResponse) && Objects.equals(securityCodeResponse, processor.securityCodeResponse);
    }

    @Override
    public int hashCode() {
        return Objects.hash(referenceNumber, authorizationCode, responseCode, network, associationResponseCode, responseMessage, avsResponse, securityCodeResponse);
    }
}
