package ar.com.sdd.fiservapi.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Components implements Serializable {

    @JsonProperty("subtotal")
    private BigDecimal subtotal;

    @JsonProperty("vatAmount")
    private BigDecimal vatAmount;

    @JsonProperty("localTax")
    private BigDecimal localTax;

    @JsonProperty("shipping")
    private BigDecimal shipping;

    @JsonProperty("cashback")
    private BigDecimal cashback;

    @JsonProperty("tip")
    private BigDecimal tip;

    @JsonProperty("surcharge")
    private BigDecimal surcharge;


    public BigDecimal getSubtotal() {
        return subtotal;
    }

    public void setSubtotal(BigDecimal subtotal) {
        this.subtotal = subtotal;
    }

    public BigDecimal getVatAmount() {
        return vatAmount;
    }

    public void setVatAmount(BigDecimal vatAmount) {
        this.vatAmount = vatAmount;
    }

    public BigDecimal getLocalTax() {
        return localTax;
    }

    public void setLocalTax(BigDecimal localTax) {
        this.localTax = localTax;
    }

    public BigDecimal getShipping() {
        return shipping;
    }

    public void setShipping(BigDecimal shipping) {
        this.shipping = shipping;
    }

    public BigDecimal getCashback() {
        return cashback;
    }

    public void setCashback(BigDecimal cashback) {
        this.cashback = cashback;
    }

    public BigDecimal getTip() {
        return tip;
    }

    public void setTip(BigDecimal tip) {
        this.tip = tip;
    }

    public BigDecimal getSurcharge() {
        return surcharge;
    }

    public void setSurcharge(BigDecimal surcharge) {
        this.surcharge = surcharge;
    }

    @Override
    public String toString() {
        return "Components [" +
                ((subtotal != null) ? "subtotal=" + subtotal + ", " : "") +
                ((vatAmount != null) ? "vatAmount=" + vatAmount + ", " : "") +
                ((localTax != null) ? "localTax=" + localTax + ", " : "") +
                ((shipping != null) ? "shipping=" + shipping + ", " : "") +
                ((cashback != null) ? "cashback=" + cashback + ", " : "") +
                ((tip != null) ? "tip=" + tip + ", " : "") +
                ((surcharge != null) ? "surcharge=" + surcharge + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Components that = (Components) o;
        return Objects.equals(subtotal, that.subtotal) && Objects.equals(vatAmount, that.vatAmount) && Objects.equals(localTax, that.localTax) && Objects.equals(shipping, that.shipping) && Objects.equals(cashback, that.cashback) && Objects.equals(tip, that.tip) && Objects.equals(surcharge, that.surcharge);
    }

    @Override
    public int hashCode() {
        return Objects.hash(subtotal, vatAmount, localTax, shipping, cashback, tip, surcharge);
    }
}
