package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstallmentOptions implements Serializable {

    @JsonProperty("numberOfInstallments")
    private Integer numberOfInstallments;


    public Integer getNumberOfInstallments() {
        return numberOfInstallments;
    }

    public void setNumberOfInstallments(Integer numberOfInstallments) {
        this.numberOfInstallments = numberOfInstallments;
    }

    @Override
    public String toString() {
        return "InstallmentOptions [" +
                ((numberOfInstallments != null) ? "numberOfInstallments=" + numberOfInstallments + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InstallmentOptions that = (InstallmentOptions) o;
        return Objects.equals(numberOfInstallments, that.numberOfInstallments);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(numberOfInstallments);
    }
}
