/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.fiservapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.core.RestSignSecurityManager;
import ar.com.sdd.fiservapi.core.FiservApiConnectorContext;
import ar.com.sdd.fiservapi.io.CommonResponse;
import ar.com.sdd.fiservapi.io.PaymentCardCreditTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentCardPayerAuthTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentCardPaymentTokenizationRequest;
import ar.com.sdd.fiservapi.io.PaymentCardPaymentTokenizationResponse;
import ar.com.sdd.fiservapi.io.PaymentCardPreAuthTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentCardSaleTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentTokenCreditTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentTokenPreAuthTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentTokenSaleTransactionRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FiservApiConnector
implements RestSignSecurityManager {
    private static final Logger log = LogManager.getLogger(FiservApiConnector.class);
    private final RestConnector restConnector;
    private final String accessTokenBaseUrl;
    private final String xApiKey;
    private final String xApiSecret;
    private final String clientId;
    private final String username;
    private final String password;
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_WAIT_MILIS = 200;

    public FiservApiConnector(FiservApiConnectorContext context) {
        this.accessTokenBaseUrl = context.getAccessTokenBaseUrl();
        this.clientId = context.getClientId();
        this.username = context.getUsername();
        this.password = context.getPassword();
        this.xApiKey = context.getXApiKey();
        this.xApiSecret = context.getXApiSecret();
        log.trace("Creando FiservApiConnector para url [{}]", (Object)context.getBaseUrl());
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public CommonResponse createPaymentCardCreditTransaction(PaymentCardCreditTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardCreditTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse getPaymentCardCreditTransactionStatus(PaymentCardCreditTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardCreditTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse createPaymentCardPayerAuthTransaction(PaymentCardPayerAuthTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardPayerAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse getPaymentCardPayerAuthTransactionStatus(PaymentCardPayerAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardPayerAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse createPaymentCardPreAuthTransaction(PaymentCardPreAuthTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardPreAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse getPaymentCardPreAuthTransactionStatus(PaymentCardPreAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardPreAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse createPaymentCardSaleTransaction(PaymentCardSaleTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardSaleTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse getPaymentCardSaleTransactionStatus(PaymentCardSaleTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardSaleTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse createPaymentTokenCreditTransaction(PaymentTokenCreditTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentTokenCreditTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse getPaymentTokenCreditTransactionStatus(PaymentTokenCreditTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenCreditTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse createPaymentTokenPreAuthTransaction(PaymentTokenPreAuthTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentTokenPreAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse getPaymentTokenPreAuthTransactionStatus(PaymentTokenPreAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenPreAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
    }

    public CommonResponse createPaymentTokenSaleTransaction(PaymentTokenSaleTransactionRequest request) throws RestConnectorException, JsonProcessingException {
        String path = "/payments";
        log.debug("[createPaymentTokenSaleTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        ObjectMapper objectMapper = new ObjectMapper();
        String stringRequest = objectMapper.writeValueAsString((Object)request);
        return (CommonResponse)this.restConnector.genericPost((Object)stringRequest, CommonResponse.class, "/payments", "application/json", "application/json");
    }

    public CommonResponse getPaymentTokenSaleTransactionStatus(PaymentTokenSaleTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenSaleTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
    }

    public PaymentCardPaymentTokenizationResponse createCardPaymentTokenization(PaymentCardPaymentTokenizationRequest request) throws RestConnectorException {
        String path = "/payment-tokens";
        log.debug("[createPaymentToken] Request POST por la creacion de un token, request [{}] path [{}]", (Object)request, (Object)"/payment-tokens");
        PaymentCardPaymentTokenizationResponse response = (PaymentCardPaymentTokenizationResponse)this.restConnector.genericPost((Object)request, PaymentCardPaymentTokenizationResponse.class, "/payment-tokens", "application/json", "application/x-www-form-urlencoded");
        log.debug("[createPaymentToken] Response POST por la creacion de un token, response [{}]", (Object)response);
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        throw new NotImplementedException("user addHeader con dos parametros");
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder, String requestBody) throws RestConnectorException {
        String clientRequestId = UUID.randomUUID().toString();
        String timestamp = Long.toString(Instant.now().toEpochMilli());
        if (builder != null) {
            builder.header("Content-Type", (Object)"application/json");
            builder.header("Api-Key", (Object)this.xApiKey);
            builder.header("Timestamp", (Object)timestamp);
            builder.header("Message-Signature", (Object)this.generateMessageSignature(clientRequestId, timestamp, requestBody));
            builder.header("Client-Request-Id", (Object)clientRequestId);
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public String generateMessageSignature(String clientRequestId, String timestamp, String jsonBody) {
        String encoded = null;
        try {
            String cleanedJsonBody = jsonBody.replaceAll("\\s+", "");
            String message = this.xApiKey + clientRequestId + timestamp + cleanedJsonBody;
            Mac hmac256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.xApiSecret.getBytes("UTF-8"), "HmacSHA256");
            hmac256.init(secretKeySpec);
            byte[] signature = hmac256.doFinal(message.getBytes("UTF-8"));
            encoded = Base64.getEncoder().encodeToString(signature);
        }
        catch (Exception e) {
            log.error("Error al generar la Message-Signature", (Throwable)e);
        }
        return encoded;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

