package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Document implements Serializable {

    public enum Type {
        NATIONAL_IDENTITY,
        SINGLE_TAX_IDENTIFICATION,
        SINGLE_CODE_OF_LABOR_IDENTIFICATION,
        BOOK_ENLISTMENT,
        CIVIC_NOTEBOOK,
        PASSPORT
    }

    @JsonProperty("type")
    private Type type;

    @JsonProperty("number")
    private String number;


    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    public String toString() {
        return "Document [" +
                ((type != null) ? "type=" + type + ", " : "") +
                ((number != null) ? "number='" + number + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Document document = (Document) o;
        return type == document.type && Objects.equals(number, document.number);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, number);
    }
}
