package ar.com.sdd.fiservapi.model.card;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CurrencyConversion implements Serializable {

    @JsonProperty("conversionType")
    private String conversionType;

    @JsonProperty("inquiryRateId")
    private String inquiryRateId;


    public String getConversionType() {
        return conversionType;
    }

    public void setConversionType(String conversionType) {
        this.conversionType = conversionType;
    }

    public String getInquiryRateId() {
        return inquiryRateId;
    }

    public void setInquiryRateId(String inquiryRateId) {
        this.inquiryRateId = inquiryRateId;
    }

    @Override
    public String toString() {
        return "CurrencyConversion [" +
                ((conversionType != null) ? "conversionType='" + conversionType + "', " : "") +
                ((inquiryRateId != null) ? "inquiryRateId='" + inquiryRateId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CurrencyConversion that = (CurrencyConversion) o;
        return Objects.equals(conversionType, that.conversionType) && Objects.equals(inquiryRateId, that.inquiryRateId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(conversionType, inquiryRateId);
    }
}
