package ar.com.sdd.fiservapi.io;

import ar.com.sdd.fiservapi.io.secure3d.AuthenticationResponse;
import ar.com.sdd.fiservapi.model.TransactionAmount;
import ar.com.sdd.fiservapi.model.response.ApprovedAmount;
import ar.com.sdd.fiservapi.model.response.Processor;
import ar.com.sdd.fiservapi.model.response.RequiredActions;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CommonResponse extends CommonError implements Serializable {

    @JsonProperty("clientRequestId")
    private String clientRequestId;

    @JsonProperty("apiTraceId")
    private String apiTraceId;

    @JsonProperty("ipgTransactionId")
    private String ipgTransactionId;

    @JsonProperty("transactionTime")
    private Long transactionTime;

    @JsonProperty("approvedAmount")
    private ApprovedAmount approvedAmount;

    @JsonProperty("transactionAmount")
    private TransactionAmount transactionAmount;

    @JsonProperty("transactionStatus")
    private String transactionStatus;

    @JsonProperty("transactionResult")
    private String transactionResult;

    @JsonProperty("schemeTransactionId")
    private String schemeTransactionId;

    @JsonProperty("processor")
    private Processor processor;

    @JsonProperty("plannedDueDate")
    private String plannedDueDate;

    @JsonProperty("requiredActions")
    private RequiredActions requiredActions;

    @JsonProperty("authenticationResponse")
    private AuthenticationResponse authenticationResponse;


    public String getClientRequestId() {
        return clientRequestId;
    }

    public void setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
    }

    public String getApiTraceId() {
        return apiTraceId;
    }

    public void setApiTraceId(String apiTraceId) {
        this.apiTraceId = apiTraceId;
    }

    public String getIpgTransactionId() {
        return ipgTransactionId;
    }

    public void setIpgTransactionId(String ipgTransactionId) {
        this.ipgTransactionId = ipgTransactionId;
    }

    public Long getTransactionTime() {
        return transactionTime;
    }

    public void setTransactionTime(Long transactionTime) {
        this.transactionTime = transactionTime;
    }

    public ApprovedAmount getApprovedAmount() {
        return approvedAmount;
    }

    public void setApprovedAmount(ApprovedAmount approvedAmount) {
        this.approvedAmount = approvedAmount;
    }

    public TransactionAmount getTransactionAmount() {
        return transactionAmount;
    }

    public void setTransactionAmount(TransactionAmount transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public String getTransactionStatus() {
        return transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public String getTransactionResult() {
        return transactionResult;
    }

    public void setTransactionResult(String transactionResult) {
        this.transactionResult = transactionResult;
    }

    public String getSchemeTransactionId() {
        return schemeTransactionId;
    }

    public void setSchemeTransactionId(String schemeTransactionId) {
        this.schemeTransactionId = schemeTransactionId;
    }

    public Processor getProcessor() {
        return processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public String getPlannedDueDate() {
        return plannedDueDate;
    }

    public void setPlannedDueDate(String plannedDueDate) {
        this.plannedDueDate = plannedDueDate;
    }

    public RequiredActions getRequiredActions() {
        return requiredActions;
    }

    public void setRequiredActions(RequiredActions requiredActions) {
        this.requiredActions = requiredActions;
    }

    public AuthenticationResponse getAuthenticationResponse() {
        return authenticationResponse;
    }

    public void setAuthenticationResponse(AuthenticationResponse authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
    }

    @Override
    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return super.toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CommonResponse that = (CommonResponse) o;
        return Objects.equals(clientRequestId, that.clientRequestId) && Objects.equals(apiTraceId, that.apiTraceId) && Objects.equals(ipgTransactionId, that.ipgTransactionId) && Objects.equals(transactionTime, that.transactionTime) && Objects.equals(approvedAmount, that.approvedAmount) && Objects.equals(transactionAmount, that.transactionAmount) && Objects.equals(transactionStatus, that.transactionStatus) && Objects.equals(transactionResult, that.transactionResult) && Objects.equals(schemeTransactionId, that.schemeTransactionId) && Objects.equals(processor, that.processor) && Objects.equals(plannedDueDate, that.plannedDueDate) && Objects.equals(requiredActions, that.requiredActions) && Objects.equals(authenticationResponse, that.authenticationResponse);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), clientRequestId, apiTraceId, ipgTransactionId, transactionTime, approvedAmount, transactionAmount, transactionStatus, transactionResult, schemeTransactionId, processor, plannedDueDate, requiredActions, authenticationResponse);
    }
}
