package ar.com.sdd.fiservapi.io;

import ar.com.sdd.fiservapi.model.card.PaymentCard;
import ar.com.sdd.fiservapi.model.response.tokenization.NetworkToken;
import ar.com.sdd.fiservapi.model.response.tokenization.PaymentToken;
import ar.com.sdd.fiservapi.model.response.tokenization.Processor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentCardPaymentTokenizationResponse implements Serializable {

    @JsonProperty("requestStatus")
    private String requestStatus;

    @JsonProperty("requestTime")
    private Long requestTime;

    @JsonProperty("brand")
    private String brand;

    @JsonProperty("country")
    private String country;

    @JsonProperty("paymentToken")
    private PaymentToken paymentToken;

    @JsonProperty("paymentCard")
    private PaymentCard paymentCard;

    @JsonProperty("networkToken")
    private NetworkToken networkToken;

    @JsonProperty("processor")
    private Processor processor;

    @JsonProperty("orderId")
    private String orderId;

    @JsonProperty("ipgTransactionId")
    private String ipgTransactionId;

    @JsonProperty("merchantTransactionId")
    private String merchantTransactionId;


    public String getRequestStatus() {
        return requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public Long getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(Long requestTime) {
        this.requestTime = requestTime;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public PaymentToken getPaymentToken() {
        return paymentToken;
    }

    public void setPaymentToken(PaymentToken paymentToken) {
        this.paymentToken = paymentToken;
    }

    public PaymentCard getPaymentCard() {
        return paymentCard;
    }

    public void setPaymentCard(PaymentCard paymentCard) {
        this.paymentCard = paymentCard;
    }

    public NetworkToken getNetworkToken() {
        return networkToken;
    }

    public void setNetworkToken(NetworkToken networkToken) {
        this.networkToken = networkToken;
    }

    public Processor getProcessor() {
        return processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getIpgTransactionId() {
        return ipgTransactionId;
    }

    public void setIpgTransactionId(String ipgTransactionId) {
        this.ipgTransactionId = ipgTransactionId;
    }

    public String getMerchantTransactionId() {
        return merchantTransactionId;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    @Override
    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return super.toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentCardPaymentTokenizationResponse that = (PaymentCardPaymentTokenizationResponse) o;
        return Objects.equals(requestStatus, that.requestStatus) && Objects.equals(requestTime, that.requestTime) && Objects.equals(brand, that.brand) && Objects.equals(country, that.country) && Objects.equals(paymentToken, that.paymentToken) && Objects.equals(paymentCard, that.paymentCard) && Objects.equals(networkToken, that.networkToken) && Objects.equals(processor, that.processor) && Objects.equals(orderId, that.orderId) && Objects.equals(ipgTransactionId, that.ipgTransactionId) && Objects.equals(merchantTransactionId, that.merchantTransactionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestStatus, requestTime, brand, country, paymentToken, paymentCard, networkToken, processor, orderId, ipgTransactionId, merchantTransactionId);
    }
}
