package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Order implements Serializable {

    @JsonProperty("orderId")
    private String orderId;

    @JsonProperty("standInDetails")
    private StandInDetails standInDetails;

    @JsonProperty("additionalDetails")
    private AdditionalDetails additionalDetails;

    @JsonProperty("bancontactQR")
    private BancontactQR bancontactQR;

    @JsonProperty("recurringPaymentDetails")
    private RecurringPaymentDetails recurringPaymentDetails;

    @JsonProperty("installmentOptions")
    private InstallmentOptions installmentOptions;


    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public StandInDetails getStandInDetails() {
        return standInDetails;
    }

    public void setStandInDetails(StandInDetails standInDetails) {
        this.standInDetails = standInDetails;
    }

    public AdditionalDetails getAdditionalDetails() {
        return additionalDetails;
    }

    public void setAdditionalDetails(AdditionalDetails additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public BancontactQR getBancontactQR() {
        return bancontactQR;
    }

    public void setBancontactQR(BancontactQR bancontactQR) {
        this.bancontactQR = bancontactQR;
    }

    public RecurringPaymentDetails getRecurringPaymentDetails() {
        return recurringPaymentDetails;
    }

    public void setRecurringPaymentDetails(RecurringPaymentDetails recurringPaymentDetails) {
        this.recurringPaymentDetails = recurringPaymentDetails;
    }

    public InstallmentOptions getInstallmentOptions() {
        return installmentOptions;
    }

    public void setInstallmentOptions(InstallmentOptions installmentOptions) {
        this.installmentOptions = installmentOptions;
    }

    @Override
    public String toString() {
        return "Order [" +
                ((orderId != null) ? "orderId='" + orderId + "', " : "") +
                ((standInDetails != null) ? "standInDetails=" + standInDetails + ", " : "") +
                ((additionalDetails != null) ? "additionalDetails=" + additionalDetails + ", " : "") +
                ((bancontactQR != null) ? "bancontactQR=" + bancontactQR + ", " : "") +
                ((recurringPaymentDetails != null) ? "recurringPaymentDetails=" + recurringPaymentDetails + ", " : "") +
                ((installmentOptions != null) ? "installmentOptions=" + installmentOptions + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Order order = (Order) o;
        return Objects.equals(orderId, order.orderId) && Objects.equals(standInDetails, order.standInDetails) && Objects.equals(additionalDetails, order.additionalDetails) && Objects.equals(bancontactQR, order.bancontactQR) && Objects.equals(recurringPaymentDetails, order.recurringPaymentDetails) && Objects.equals(installmentOptions, order.installmentOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderId, standInDetails, additionalDetails, bancontactQR, recurringPaymentDetails, installmentOptions);
    }
}