package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class StandInDetails implements Serializable {

    public enum StandInType {
        FIXED_AMOUNT,
        MAXIMUM_AMOUNT
    }

    public enum Frequency {
        DAILY,
        TWICEWEEKLY,
        WEEKLY,
        TENDAYS,
        FORTNIGHTLY,
        MONTHLY,
        EVERYTWOMONTHS,
        TRIMESTER,
        QUARTERLY,
        HALFYEARLY,
        YEARLY,
        UNSCHEDULED
    }

    @JsonProperty("standInType")
    private StandInType standInType;

    @JsonProperty("numberOfDebits")
    private String numberOfDebits;

    @JsonProperty("siValidated")
    private Boolean siValidated;

    @JsonProperty("maximumTransactionAmount")
    private BigDecimal maximumTransactionAmount;

    @JsonProperty("siHubId")
    private String siHubId;

    @JsonProperty("frequency")
    private Frequency frequency;


    public StandInType getStandInType() {
        return standInType;
    }

    public void setStandInType(StandInType standInType) {
        this.standInType = standInType;
    }

    public String getNumberOfDebits() {
        return numberOfDebits;
    }

    public void setNumberOfDebits(String numberOfDebits) {
        this.numberOfDebits = numberOfDebits;
    }

    public Boolean getSiValidated() {
        return siValidated;
    }

    public void setSiValidated(Boolean siValidated) {
        this.siValidated = siValidated;
    }

    public BigDecimal getMaximumTransactionAmount() {
        return maximumTransactionAmount;
    }

    public void setMaximumTransactionAmount(BigDecimal maximumTransactionAmount) {
        this.maximumTransactionAmount = maximumTransactionAmount;
    }

    public String getSiHubId() {
        return siHubId;
    }

    public void setSiHubId(String siHubId) {
        this.siHubId = siHubId;
    }

    public Frequency getFrequency() {
        return frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    @Override
    public String toString() {
        return "StandInDetails [" +
                ((standInType != null) ? "standInType=" + standInType + ", " : "") +
                ((numberOfDebits != null) ? "numberOfDebits='" + numberOfDebits + "', " : "") +
                ((siValidated != null) ? "siValidated=" + siValidated + ", " : "") +
                ((maximumTransactionAmount != null) ? "maximumTransactionAmount=" + maximumTransactionAmount + ", " : "") +
                ((siHubId != null) ? "siHubId='" + siHubId + "', " : "") +
                ((frequency != null) ? "frequency=" + frequency + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StandInDetails that = (StandInDetails) o;
        return standInType == that.standInType && Objects.equals(numberOfDebits, that.numberOfDebits) && Objects.equals(siValidated, that.siValidated) && Objects.equals(maximumTransactionAmount, that.maximumTransactionAmount) && Objects.equals(siHubId, that.siHubId) && frequency == that.frequency;
    }

    @Override
    public int hashCode() {
        return Objects.hash(standInType, numberOfDebits, siValidated, maximumTransactionAmount, siHubId, frequency);
    }
}