package ar.com.sdd.fiservapi.model.card;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SplitShipment implements Serializable {

    @JsonProperty("totalCount")
    private Integer totalCount;

    @JsonProperty("finalShipment")
    private Boolean finalShipment = false;


    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Boolean getFinalShipment() {
        return finalShipment;
    }

    public void setFinalShipment(Boolean finalShipment) {
        this.finalShipment = finalShipment;
    }

    @Override
    public String toString() {
        return "SplitShipment [" +
                ((totalCount != null) ? "totalCount=" + totalCount + ", " : "") +
                ((finalShipment != null) ? "finalShipment=" + finalShipment + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SplitShipment that = (SplitShipment) o;
        return Objects.equals(totalCount, that.totalCount) && Objects.equals(finalShipment, that.finalShipment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(totalCount, finalShipment);
    }
}
