package ar.com.sdd.fiservapi.model.response.tokenization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateToken implements Serializable {

    @JsonProperty("value")
    private String value;

    @JsonProperty("reusable")
    private Boolean reusable = true;

    @JsonProperty("declineDuplicates")
    private Boolean declineDuplicates = false;


    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getReusable() {
        return reusable;
    }

    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public Boolean getDeclineDuplicates() {
        return declineDuplicates;
    }

    public void setDeclineDuplicates(Boolean declineDuplicates) {
        this.declineDuplicates = declineDuplicates;
    }

    @Override
    public String toString() {
        return "CreateToken [" +
                ((value != null) ? "value='" + value + "', " : "") +
                ((reusable != null) ? "reusable=" + reusable + ", " : "") +
                ((declineDuplicates != null) ? "declineDuplicates=" + declineDuplicates + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreateToken that = (CreateToken) o;
        return Objects.equals(value, that.value) && Objects.equals(reusable, that.reusable) && Objects.equals(declineDuplicates, that.declineDuplicates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, reusable, declineDuplicates);
    }
}
