package ar.com.sdd.fiservapi.model.response.tokenization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentToken implements Serializable {

    @JsonProperty("value")
    private String value;

    @JsonProperty("reusable")
    private Boolean reusable;

    @JsonProperty("declineDuplicates")
    private Boolean declineDuplicates;

    @JsonProperty("last4")
    private String last4;

    @JsonProperty("brand")
    private String brand;

    @JsonProperty("accountVerification")
    private Boolean accountVerification;

    @JsonProperty("type")
    private String type;


    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getReusable() {
        return reusable;
    }

    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public Boolean getDeclineDuplicates() {
        return declineDuplicates;
    }

    public void setDeclineDuplicates(Boolean declineDuplicates) {
        this.declineDuplicates = declineDuplicates;
    }

    public String getLast4() {
        return last4;
    }

    public void setLast4(String last4) {
        this.last4 = last4;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Boolean getAccountVerification() {
        return accountVerification;
    }

    public void setAccountVerification(Boolean accountVerification) {
        this.accountVerification = accountVerification;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "PaymentToken [" +
                ((value != null) ? "value='" + value + "', " : "") +
                ((reusable != null) ? "reusable=" + reusable + ", " : "") +
                ((declineDuplicates != null) ? "declineDuplicates=" + declineDuplicates + ", " : "") +
                ((last4 != null) ? "last4='" + last4 + "', " : "") +
                ((brand != null) ? "brand='" + brand + "', " : "") +
                ((accountVerification != null) ? "accountVerification=" + accountVerification + ", " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentToken that = (PaymentToken) o;
        return Objects.equals(value, that.value) && Objects.equals(reusable, that.reusable) && Objects.equals(declineDuplicates, that.declineDuplicates) && Objects.equals(last4, that.last4) && Objects.equals(brand, that.brand) && Objects.equals(accountVerification, that.accountVerification) && Objects.equals(type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, reusable, declineDuplicates, last4, brand, accountVerification, type);
    }
}
