package ar.com.sdd.fiservapi.model.secure3d;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Secure3dMethod implements Serializable {

    @JsonProperty("methodForm")
    private String methodForm;

    @JsonProperty("secure3dTransId")
    private String secure3dTransId;


    public String getMethodForm() {
        return methodForm;
    }

    public void setMethodForm(String methodForm) {
        this.methodForm = methodForm;
    }

    public String getSecure3dTransId() {
        return secure3dTransId;
    }

    public void setSecure3dTransId(String secure3dTransId) {
        this.secure3dTransId = secure3dTransId;
    }

    @Override
    public String toString() {
        return "Secure3dMethod [" +
                ((methodForm != null) ? "methodForm='" + methodForm + "', " : "") +
                ((secure3dTransId != null) ? "secure3dTransId='" + secure3dTransId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Secure3dMethod that = (Secure3dMethod) o;
        return Objects.equals(methodForm, that.methodForm) && Objects.equals(secure3dTransId, that.secure3dTransId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(methodForm, secure3dTransId);
    }
}
