package ar.com.sdd.getnetapi.io;

import ar.com.sdd.getnetapi.model.Customer;
import ar.com.sdd.getnetapi.model.Payment;
import ar.com.sdd.getnetapi.model.Product;
import ar.com.sdd.getnetapi.model.Shipping;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentIntentRequest implements Serializable {

    @JsonProperty("customer")
    private Customer customer;

    @JsonProperty("shipping")
    private Shipping shipping;

    @JsonProperty("product")
    private List<Product> product;

    @JsonProperty("payment")
    private Payment payment;

    @JsonProperty("mode")
    private String mode;

    @JsonProperty("pickup_store")
    private String pickupStore;

    @JsonProperty("shipping_method")
    private String shippingMethod;

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Shipping getShipping() {
        return shipping;
    }

    public void setShipping(Shipping shipping) {
        this.shipping = shipping;
    }

    public List<Product> getProduct() {
        return product;
    }

    public void setProduct(List<Product> product) {
        this.product = product;
    }

    public Payment getPayment() {
        return payment;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPickupStore() {
        return pickupStore;
    }

    public void setPickupStore(String pickupStore) {
        this.pickupStore = pickupStore;
    }

    public String getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    @Override
    public String toString() {
        return "PaymentIntentRequest [" +
                ((customer != null) ? "customer=" + customer + ", " : "") +
                ((shipping != null) ? "shipping=" + shipping + ", " : "") +
                ((product != null) ? "product=" + Arrays.toString(product.toArray()) + ", " : "") +
                ((payment != null) ? "payment=" + payment + ", " : "") +
                ((mode != null) ? "mode='" + mode + "', " : "") +
                ((pickupStore != null) ? "pickupStore='" + pickupStore + "', " : "") +
                ((shippingMethod != null) ? "shippingMethod='" + shippingMethod + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentIntentRequest that = (PaymentIntentRequest) o;
        return Objects.equals(customer, that.customer) && Objects.equals(shipping, that.shipping) && Objects.equals(product, that.product) && Objects.equals(payment, that.payment) && Objects.equals(mode, that.mode) && Objects.equals(pickupStore, that.pickupStore) && Objects.equals(shippingMethod, that.shippingMethod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(customer, shipping, product, payment, mode, pickupStore, shippingMethod);
    }
}