/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.getnetapi.model;

import ar.com.sdd.commons.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Payment
implements Serializable {
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="amount")
    private Integer amount;

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Integer getAmount() {
        return this.amount;
    }

    @JsonIgnore
    public BigDecimal getAmountAsBigDecimal() {
        return this.amount != null ? NumberUtil.divideToBigDecimal((BigDecimal)new BigDecimal(this.amount), (BigDecimal)NumberUtil.CIEN_SCALED) : null;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = NumberUtil.multiplyToBigDecimal((BigDecimal)amount, (BigDecimal)NumberUtil.CIEN_SCALED).intValue();
    }

    public String toString() {
        return "Payment [" + (String)(this.currency != null ? "currency='" + this.currency + "', " : "") + (String)(this.amount != null ? "amount=" + this.amount + ", " : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.currency, payment.currency) && Objects.equals(this.amount, payment.amount);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.amount);
    }
}

