package ar.com.sdd.getnetapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Frontend implements Serializable {

    @JsonProperty("link")
    private String link;

    @JsonProperty("time_page")
    private Integer timePage;

    @JsonProperty("sales_channel")
    private String salesChannel;

    @JsonProperty("application_version")
    private String applicationVersion;

    @JsonProperty("card_pasted")
    private Boolean cardPasted;

    @JsonProperty("ip")
    private String ip;

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Integer getTimePage() {
        return timePage;
    }

    public void setTimePage(Integer timePage) {
        this.timePage = timePage;
    }

    public String getSalesChannel() {
        return salesChannel;
    }

    public void setSalesChannel(String salesChannel) {
        this.salesChannel = salesChannel;
    }

    public String getApplicationVersion() {
        return applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public Boolean getCardPasted() {
        return cardPasted;
    }

    public void setCardPasted(Boolean cardPasted) {
        this.cardPasted = cardPasted;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @Override
    public String toString() {
        return "Frontend [" +
                ((link != null) ? "link='" + link + "', " : "") +
                ((timePage != null) ? "timePage=" + timePage + ", " : "") +
                ((salesChannel != null) ? "salesChannel='" + salesChannel + "', " : "") +
                ((applicationVersion != null) ? "applicationVersion='" + applicationVersion + "', " : "") +
                ((cardPasted != null) ? "cardPasted=" + cardPasted + ", " : "") +
                ((ip != null) ? "ip='" + ip + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Frontend frontend = (Frontend) o;
        return Objects.equals(link, frontend.link) && Objects.equals(timePage, frontend.timePage) && Objects.equals(salesChannel, frontend.salesChannel) && Objects.equals(applicationVersion, frontend.applicationVersion) && Objects.equals(cardPasted, frontend.cardPasted) && Objects.equals(ip, frontend.ip);
    }

    @Override
    public int hashCode() {
        return Objects.hash(link, timePage, salesChannel, applicationVersion, cardPasted, ip);
    }
}