package ar.com.sdd.getnetapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentWebhookNotification implements Serializable {

    @JsonProperty("checkout_id")
    private String checkoutId;

    @JsonProperty("payment_intent_id")
    private String paymentIntentId;

    @JsonProperty("mode")
    private String mode;

    @JsonProperty("seller")
    private Seller seller;

    @JsonProperty("customer")
    private Customer customer;

    @JsonProperty("shipping")
    private Shipping shipping;

    @JsonProperty("payment")
    private Payment payment;

    @JsonProperty("pickup_store")
    private Boolean pickupStore;

    @JsonProperty("shipping_method")
    private String shippingMethod;

    @JsonProperty("product")
    private List<Product> products;

    @JsonProperty("frontend")
    private Frontend frontend;

    @JsonProperty("created_at")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date createdAt;

    @JsonProperty("updated_at")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date updatedAt;

    public String getCheckoutId() {
        return checkoutId;
    }

    public void setCheckoutId(String checkoutId) {
        this.checkoutId = checkoutId;
    }

    public String getPaymentIntentId() {
        return paymentIntentId;
    }

    public void setPaymentIntentId(String paymentIntentId) {
        this.paymentIntentId = paymentIntentId;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Seller getSeller() {
        return seller;
    }

    public void setSeller(Seller seller) {
        this.seller = seller;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Shipping getShipping() {
        return shipping;
    }

    public void setShipping(Shipping shipping) {
        this.shipping = shipping;
    }

    public Payment getPayment() {
        return payment;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public Boolean getPickupStore() {
        return pickupStore;
    }

    public void setPickupStore(Boolean pickupStore) {
        this.pickupStore = pickupStore;
    }

    public String getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public List<Product> getProducts() {
        return products;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public Frontend getFrontend() {
        return frontend;
    }

    public void setFrontend(Frontend frontend) {
        this.frontend = frontend;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public String toString() {
        return "PaymentWebhookNotification [" +
                ((checkoutId != null) ? "checkoutId='" + checkoutId + "', " : "") +
                ((paymentIntentId != null) ? "paymentIntentId='" + paymentIntentId + "', " : "") +
                ((mode != null) ? "mode='" + mode + "', " : "") +
                ((seller != null) ? "seller=" + seller + ", " : "") +
                ((customer != null) ? "customer=" + customer + ", " : "") +
                ((shipping != null) ? "shipping=" + shipping + ", " : "") +
                ((payment != null) ? "payment=" + payment + ", " : "") +
                ((pickupStore != null) ? "pickupStore=" + pickupStore + ", " : "") +
                ((shippingMethod != null) ? "shippingMethod='" + shippingMethod + "', " : "") +
                ((products != null) ? "products=" + Arrays.toString(products.toArray()) + ", " : "") +
                ((frontend != null) ? "frontend=" + frontend + ", " : "") +
                ((createdAt != null) ? "createdAt=" + createdAt + ", " : "") +
                ((updatedAt != null) ? "updatedAt=" + updatedAt + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentWebhookNotification that = (PaymentWebhookNotification) o;
        return Objects.equals(checkoutId, that.checkoutId) && Objects.equals(paymentIntentId, that.paymentIntentId) && Objects.equals(mode, that.mode) && Objects.equals(seller, that.seller) && Objects.equals(customer, that.customer) && Objects.equals(shipping, that.shipping) && Objects.equals(payment, that.payment) && Objects.equals(pickupStore, that.pickupStore) && Objects.equals(shippingMethod, that.shippingMethod) && Objects.equals(products, that.products) && Objects.equals(frontend, that.frontend) && Objects.equals(createdAt, that.createdAt) && Objects.equals(updatedAt, that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(checkoutId, paymentIntentId, mode, seller, customer, shipping, payment, pickupStore, shippingMethod, products, frontend, createdAt, updatedAt);
    }
}