package ar.com.sdd.getnetapi.model;

import ar.com.sdd.commons.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Product implements Serializable {

    @JsonProperty("title")
    private String title;

    @JsonProperty("value")
    private Integer value;

    @JsonProperty("quantity")
    private Integer quantity;

    @JsonProperty("product_type")
    private String productType;

    @JsonProperty("description")
    private String description;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getValue() {
        return value;
    }

    @JsonIgnore
    public BigDecimal getValueAsBigDecimal() {
        return value != null ? NumberUtil.divideToBigDecimal(new BigDecimal(value), NumberUtil.CIEN_SCALED) : null;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public void setValue(BigDecimal value) {
        this.value = NumberUtil.multiplyToBigDecimal(value, NumberUtil.CIEN_SCALED).intValue();
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "Product [" +
                ((title != null) ? "title='" + title + "', " : "") +
                ((value != null) ? "value=" + value + ", " : "") +
                ((quantity != null) ? "quantity=" + quantity + ", " : "") +
                ((productType != null) ? "productType='" + productType + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Product product = (Product) o;
        return Objects.equals(title, product.title) && Objects.equals(value, product.value) && Objects.equals(quantity, product.quantity) && Objects.equals(productType, product.productType) && Objects.equals(description, product.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(title, value, quantity, productType, description);
    }
}