package ar.com.sdd.getnetapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Result implements Serializable {

    @JsonProperty("status")
    private String status;

    @JsonProperty("transaction_datetime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date transactionDatetime;

    @JsonProperty("return_message")
    private String returnMessage;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getTransactionDatetime() {
        return transactionDatetime;
    }

    public void setTransactionDatetime(Date transactionDatetime) {
        this.transactionDatetime = transactionDatetime;
    }

    public String getReturnMessage() {
        return returnMessage;
    }

    public void setReturnMessage(String returnMessage) {
        this.returnMessage = returnMessage;
    }

    @Override
    public String toString() {
        return "Result [" +
                ((status != null) ? "status='" + status + "', " : "") +
                ((transactionDatetime != null) ? "transactionDatetime='" + transactionDatetime + "', " : "") +
                ((returnMessage != null) ? "returnMessage='" + returnMessage + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Result result = (Result) o;
        return Objects.equals(status, result.status) && Objects.equals(transactionDatetime, result.transactionDatetime) && Objects.equals(returnMessage, result.returnMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, transactionDatetime, returnMessage);
    }
}