package ar.com.sdd.getnetapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Settings implements Serializable {

    @JsonProperty("notification_url_configurated")
    private Boolean notificationUrlConfigurated;

    public Boolean getNotificationUrlConfigurated() {
        return notificationUrlConfigurated;
    }

    public void setNotificationUrlConfigurated(Boolean notificationUrlConfigurated) {
        this.notificationUrlConfigurated = notificationUrlConfigurated;
    }

    @Override
    public String toString() {
        return "Settings [" +
                ((notificationUrlConfigurated != null) ? "notificationUrlConfigurated=" + notificationUrlConfigurated + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Settings settings = (Settings) o;
        return Objects.equals(notificationUrlConfigurated, settings.notificationUrlConfigurated);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(notificationUrlConfigurated);
    }
}