/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.getnetapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.ThreadUtil;
import ar.com.sdd.getnetapi.core.GetNetApiConnectorContext;
import ar.com.sdd.getnetapi.io.CommonError;
import ar.com.sdd.getnetapi.io.PaymentCancellationResponse;
import ar.com.sdd.getnetapi.io.PaymentIntentRequest;
import ar.com.sdd.getnetapi.io.PaymentIntentResponse;
import ar.com.sdd.getnetapi.io.PaymentRefundRequest;
import ar.com.sdd.getnetapi.io.PaymentRefundResponse;
import ar.com.sdd.getnetapi.io.PaymentReversalResponse;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetNetApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(GetNetApiConnector.class);
    private final RestConnector restConnector;
    private final String clientId;
    private final String clientSecret;
    private boolean doingLogin;
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_WAIT_MILIS = 200;

    public GetNetApiConnector(GetNetApiConnectorContext context) {
        this.clientId = context.getGetNetApiClientId();
        this.clientSecret = context.getGetNetApiClientSecret();
        log.trace("Creando GetNetConnector para url [{}]", (Object)context.getGetNetApiBaseUrl());
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getGetNetApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public PaymentIntentResponse createPaymentIntent(PaymentIntentRequest paymentIntentRequest) throws RestConnectorException {
        String path = "/digital-checkout/v1/payment-intent";
        log.debug("[createPaymentIntent] Request POST createPaymentIntent para el {} path [{}]", (Object)paymentIntentRequest, (Object)"/digital-checkout/v1/payment-intent");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (PaymentIntentResponse)this.restConnector.genericPost((Object)paymentIntentRequest, PaymentIntentResponse.class, CommonError.class, "/digital-checkout/v1/payment-intent");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public PaymentCancellationResponse cancelPayment(String paymentId) throws RestConnectorException {
        String path = "/digital-checkout/v1/payments/" + paymentId + "/cancellation";
        log.debug("[cancelPayment] Request POST cancelPayment para el paymentId [{}] path [{}]", (Object)paymentId, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (PaymentCancellationResponse)this.restConnector.genericPost(null, PaymentCancellationResponse.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public PaymentReversalResponse reversePayment(String paymentId) throws RestConnectorException {
        String path = "/digital-checkout/v1/payments/" + paymentId + "/reversal";
        log.debug("[reversePayment] Request POST reversePayment para el paymentId [{}] path [{}]", (Object)paymentId, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (PaymentReversalResponse)this.restConnector.genericPost(null, PaymentReversalResponse.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public PaymentRefundResponse refundPayment(String paymentId, PaymentRefundRequest paymentRefundRequest) throws RestConnectorException {
        String path = "/digital-checkout/v1/payments/" + paymentId + "/refund";
        log.debug("[refundPayment] Request POST refundPayment para el paymentId [{}] path [{}]", (Object)paymentId, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (PaymentRefundResponse)this.restConnector.genericPost((Object)paymentRefundRequest, PaymentRefundResponse.class, CommonError.class, path);
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null && !this.doingLogin) {
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken(false)));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(GetNetApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("client_id", this.clientId);
            form.param("client_secret", this.clientSecret);
            form.param("grant_type", "client_credentials");
            log.debug("[getAccessToken] Por recuperar token con clientId [{}] y clientSecret [{}]", (Object)this.clientId, (Object)this.clientSecret);
            this.doingLogin = true;
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)this.restConnector.genericPost((Object)form, TokenOAuth2.class, "/authentication/oauth2/access_token", "application/json", "application/x-www-form-urlencoded");
            this.doingLogin = false;
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}]segs. Lo agrego al a cache", (Object)tokenOAuth2Response, (Object)tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, (Object)accessToken, tokenOAuth2Response.getExpiresIn());
        }
        return accessToken;
    }
}

