package ar.com.sdd.getnetapi.io;

import ar.com.sdd.commons.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentRefundRequest implements Serializable {

    @JsonProperty("amount")
    private Integer amount;

    public PaymentRefundRequest() {
    }

    public PaymentRefundRequest(BigDecimal amount) {
        setAmount(amount);
    }

    public Integer getAmount() {
        return amount;
    }

    @JsonIgnore
    public BigDecimal getAmountAsBigDecimal() {
        return amount != null ? NumberUtil.divideToBigDecimal(new BigDecimal(amount), NumberUtil.CIEN_SCALED) : null;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonIgnore
    public void setAmount(BigDecimal amount) {
        this.amount = NumberUtil.multiplyToBigDecimal(amount, NumberUtil.CIEN_SCALED).intValue();
    }

    @Override
    public String toString() {
        return "PaymentRefundRequest [" +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentRefundRequest that = (PaymentRefundRequest) o;
        return Objects.equals(amount, that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(amount);
    }
}