package ar.com.sdd.getnetapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Result implements Serializable {

    @JsonProperty("status")
    private String status;

    @JsonProperty("transaction_datetime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date transactionDatetime;

    @JsonProperty("return_message")
    private String returnMessage;

    @JsonProperty("authorization_code")
    private String authorizationCode;

    @JsonProperty("payment_id")
    private String paymentId;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getTransactionDatetime() {
        return transactionDatetime;
    }

    public void setTransactionDatetime(Date transactionDatetime) {
        this.transactionDatetime = transactionDatetime;
    }

    public String getReturnMessage() {
        return returnMessage;
    }

    public void setReturnMessage(String returnMessage) {
        this.returnMessage = returnMessage;
    }

    public String getAuthorizationCode() {
        return authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    @Override
    public String toString() {
        return "Result [" +
                ((status != null) ? "status='" + status + "', " : "") +
                ((transactionDatetime != null) ? "transactionDatetime=" + transactionDatetime + ", " : "") +
                ((returnMessage != null) ? "returnMessage='" + returnMessage + "', " : "") +
                ((authorizationCode != null) ? "authorizationCode='" + authorizationCode + "', " : "") +
                ((paymentId != null) ? "paymentId='" + paymentId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Result result = (Result) o;
        return Objects.equals(status, result.status) && Objects.equals(transactionDatetime, result.transactionDatetime) && Objects.equals(returnMessage, result.returnMessage) && Objects.equals(authorizationCode, result.authorizationCode) && Objects.equals(paymentId, result.paymentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, transactionDatetime, returnMessage, authorizationCode, paymentId);
    }
}