package ar.com.sdd.getnetapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Seller implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("trade_name")
    private String tradeName;

    @JsonProperty("merchant_document")
    private String merchantDocument;

    @JsonProperty("settings")
    private Settings settings;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTradeName() {
        return tradeName;
    }

    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    public String getMerchantDocument() {
        return merchantDocument;
    }

    public void setMerchantDocument(String merchantDocument) {
        this.merchantDocument = merchantDocument;
    }

    public Settings getSettings() {
        return settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public String toString() {
        return "Seller [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((tradeName != null) ? "tradeName='" + tradeName + "', " : "") +
                ((merchantDocument != null) ? "merchantDocument='" + merchantDocument + "', " : "") +
                ((settings != null) ? "settings=" + settings + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Seller seller = (Seller) o;
        return Objects.equals(id, seller.id) && Objects.equals(tradeName, seller.tradeName) && Objects.equals(merchantDocument, seller.merchantDocument) && Objects.equals(settings, seller.settings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, tradeName, merchantDocument, settings);
    }
}