package ar.com.sdd.getnetapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentRefundResponse implements Serializable {

    @JsonProperty("payment_id")
    private String paymentId;

    @JsonProperty("generated_by")
    private String generatedBy;

    @JsonProperty("status")
    private String status;

    @JsonProperty("transaction_datetime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date transactionDateTime;

    @JsonProperty("authorization_code")
    private String authorizationCode;

    public String getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getGeneratedBy() {
        return generatedBy;
    }

    public void setGeneratedBy(String generatedBy) {
        this.generatedBy = generatedBy;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getTransactionDateTime() {
        return transactionDateTime;
    }

    public void setTransactionDateTime(Date transactionDateTime) {
        this.transactionDateTime = transactionDateTime;
    }

    public String getAuthorizationCode() {
        return authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @Override
    public String toString() {
        return "PaymentRefundResponse [" +
                ((paymentId != null) ? "paymentId='" + paymentId + "', " : "") +
                ((generatedBy != null) ? "generatedBy='" + generatedBy + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((transactionDateTime != null) ? "transactionDateTime=" + transactionDateTime + ", " : "") +
                ((authorizationCode != null) ? "authorizationCode='" + authorizationCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentRefundResponse that = (PaymentRefundResponse) o;
        return Objects.equals(paymentId, that.paymentId) && Objects.equals(generatedBy, that.generatedBy) && Objects.equals(status, that.status) && Objects.equals(transactionDateTime, that.transactionDateTime) && Objects.equals(authorizationCode, that.authorizationCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentId, generatedBy, status, transactionDateTime, authorizationCode);
    }
}