package ar.com.sdd.getnetapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentIntentResponse implements Serializable {

    @JsonProperty("payment_intent_id")
    private String paymentIntentId;

    @JsonProperty("redirect_url")
    private String redirectUrl;

    public String getPaymentIntentId() {
        return paymentIntentId;
    }

    public void setPaymentIntentId(String paymentIntentId) {
        this.paymentIntentId = paymentIntentId;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public String toString() {
        return "PaymentIntentResponse [" +
                ((paymentIntentId != null) ? "payment_intent_id='" + paymentIntentId + "', " : "") +
                ((redirectUrl != null) ? "redirect_url='" + redirectUrl + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentIntentResponse that = (PaymentIntentResponse) o;
        return Objects.equals(paymentIntentId, that.paymentIntentId) && Objects.equals(redirectUrl, that.redirectUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentIntentId, redirectUrl);
    }
}