package ar.com.sdd.getnetapi.model;

import ar.com.sdd.commons.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Customer implements Serializable {

    @JsonProperty("customer_id")
    private String customerId;

    @JsonProperty("first_name")
    private String firstName;

    @JsonProperty("last_name")
    private String lastName;

    @JsonProperty("name")
    private String name;

    @JsonProperty("email")
    private String email;

    @JsonProperty("document_type")
    private String documentType;

    @JsonProperty("document_number")
    private String documentNumber;

    @JsonProperty("phone_number")
    private String phoneNumber;

    @JsonProperty("gender")
    private String gender;

    @JsonProperty("checked_email")
    private Boolean checkedEmail;

    @JsonProperty("billing_address")
    private Address billingAddress;

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = StringUtil.trunc(firstName,40);
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = StringUtil.trunc(lastName,40);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Address getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public Boolean getCheckedEmail() {
        return checkedEmail;
    }

    public void setCheckedEmail(Boolean checkedEmail) {
        this.checkedEmail = checkedEmail;
    }

    @Override
    public String toString() {
        return "Customer [" +
                ((customerId != null) ? "customerId='" + customerId + "', " : "") +
                ((firstName != null) ? "firstName='" + firstName + "', " : "") +
                ((lastName != null) ? "lastName='" + lastName + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                ((documentType != null) ? "documentType='" + documentType + "', " : "") +
                ((documentNumber != null) ? "documentNumber='" + documentNumber + "', " : "") +
                ((phoneNumber != null) ? "phoneNumber='" + phoneNumber + "', " : "") +
                ((gender != null) ? "gender='" + gender + "', " : "") +
                ((checkedEmail != null) ? "checkedEmail=" + checkedEmail + ", " : "") +
                ((billingAddress != null) ? "billingAddress=" + billingAddress + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Customer customer = (Customer) o;
        return Objects.equals(customerId, customer.customerId) && Objects.equals(firstName, customer.firstName) && Objects.equals(lastName, customer.lastName) && Objects.equals(name, customer.name) && Objects.equals(email, customer.email) && Objects.equals(documentType, customer.documentType) && Objects.equals(documentNumber, customer.documentNumber) && Objects.equals(phoneNumber, customer.phoneNumber) && Objects.equals(gender, customer.gender) && Objects.equals(checkedEmail, customer.checkedEmail) && Objects.equals(billingAddress, customer.billingAddress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(customerId, firstName, lastName, name, email, documentType, documentNumber, phoneNumber, gender, checkedEmail, billingAddress);
    }
}