package ar.com.sdd.getnetapi.model;

import ar.com.sdd.commons.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Payment implements Serializable {

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("amount")
    private Integer amount;

    @JsonProperty("method")
    private String method;

    @JsonProperty("installment")
    private Installment installment;

    @JsonProperty("result")
    private Result result;

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Integer getAmount() {
        return amount;
    }

    @JsonIgnore
    public BigDecimal getAmountAsBigDecimal() {
        return amount != null ? NumberUtil.divideToBigDecimal(new BigDecimal(amount), NumberUtil.CIEN_SCALED) : null;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonIgnore
    public void setAmount(BigDecimal amount) {
        this.amount = NumberUtil.multiplyToBigDecimal(amount, NumberUtil.CIEN_SCALED).intValue();
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Installment getInstallment() {
        return installment;
    }

    public void setInstallment(Installment installment) {
        this.installment = installment;
    }

    public Result getResult() {
        return result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "Payment [" +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((method != null) ? "method='" + method + "', " : "") +
                ((installment != null) ? "installment=" + installment + ", " : "") +
                ((result != null) ? "result=" + result + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Payment payment = (Payment) o;
        return Objects.equals(currency, payment.currency) && Objects.equals(amount, payment.amount) && Objects.equals(method, payment.method) && Objects.equals(installment, payment.installment) && Objects.equals(result, payment.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, amount, method, installment, result);
    }
}