package ar.com.sdd.getnetapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Shipping implements Serializable {

    @JsonProperty("first_name")
    private String firstName;

    @JsonProperty("last_name")
    private String lastName;

    @JsonProperty("name")
    private String name;

    @JsonProperty("phone_number")
    private String phoneNumber;

    @JsonProperty("shipping_amount")
    private Integer shippingAmount;

    @JsonProperty("address")
    private Address address;

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Address getAddress() {
        return address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Integer getShippingAmount() {
        return shippingAmount;
    }

    public void setShippingAmount(Integer shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    @Override
    public String toString() {
        return "Shipping [" +
                ((firstName != null) ? "firstName='" + firstName + "', " : "") +
                ((lastName != null) ? "lastName='" + lastName + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((phoneNumber != null) ? "phoneNumber='" + phoneNumber + "', " : "") +
                ((shippingAmount != null) ? "shippingAmount=" + shippingAmount + ", " : "") +
                ((address != null) ? "address=" + address + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Shipping shipping = (Shipping) o;
        return Objects.equals(firstName, shipping.firstName) && Objects.equals(lastName, shipping.lastName) && Objects.equals(name, shipping.name) && Objects.equals(phoneNumber, shipping.phoneNumber) && Objects.equals(shippingAmount, shipping.shippingAmount) && Objects.equals(address, shipping.address);
    }

    @Override
    public int hashCode() {
        return Objects.hash(firstName, lastName, name, phoneNumber, shippingAmount, address);
    }
}