/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.getnetapi.io;

import ar.com.sdd.commons.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentRefundRequest
implements Serializable {
    @JsonProperty(value="amount")
    private Integer amount;

    public PaymentRefundRequest() {
    }

    public PaymentRefundRequest(BigDecimal amount) {
        this.setAmount(amount);
    }

    public Integer getAmount() {
        return this.amount;
    }

    @JsonIgnore
    public BigDecimal getAmountAsBigDecimal() {
        return this.amount != null ? NumberUtil.divideToBigDecimal((BigDecimal)new BigDecimal(this.amount), (BigDecimal)NumberUtil.CIEN_SCALED) : null;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonIgnore
    public void setAmount(BigDecimal amount) {
        this.amount = NumberUtil.multiplyToBigDecimal((BigDecimal)amount, (BigDecimal)NumberUtil.CIEN_SCALED).intValue();
    }

    public String toString() {
        return "PaymentRefundRequest [" + (String)(this.amount != null ? "amount=" + this.amount + ", " : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRefundRequest that = (PaymentRefundRequest)o;
        return Objects.equals(this.amount, that.amount);
    }

    public int hashCode() {
        return Objects.hashCode(this.amount);
    }
}

