/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.getnetapi.model;

import ar.com.sdd.commons.util.NumberUtil;
import ar.com.sdd.getnetapi.model.Installment;
import ar.com.sdd.getnetapi.model.Result;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Payment
implements Serializable {
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="amount")
    private Integer amount;
    @JsonProperty(value="method")
    private String method;
    @JsonProperty(value="installment")
    private Installment installment;
    @JsonProperty(value="result")
    private Result result;

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Integer getAmount() {
        return this.amount;
    }

    @JsonIgnore
    public BigDecimal getAmountAsBigDecimal() {
        return this.amount != null ? NumberUtil.divideToBigDecimal((BigDecimal)new BigDecimal(this.amount), (BigDecimal)NumberUtil.CIEN_SCALED) : null;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonIgnore
    public void setAmount(BigDecimal amount) {
        this.amount = NumberUtil.multiplyToBigDecimal((BigDecimal)amount, (BigDecimal)NumberUtil.CIEN_SCALED).intValue();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Installment getInstallment() {
        return this.installment;
    }

    public void setInstallment(Installment installment) {
        this.installment = installment;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public String toString() {
        return "Payment [" + (String)(this.currency != null ? "currency='" + this.currency + "', " : "") + (String)(this.amount != null ? "amount=" + this.amount + ", " : "") + (String)(this.method != null ? "method='" + this.method + "', " : "") + (String)(this.installment != null ? "installment=" + this.installment + ", " : "") + (String)(this.result != null ? "result=" + this.result + ", " : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.currency, payment.currency) && Objects.equals(this.amount, payment.amount) && Objects.equals(this.method, payment.method) && Objects.equals(this.installment, payment.installment) && Objects.equals(this.result, payment.result);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.amount, this.method, this.installment, this.result);
    }
}

