/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.getnetapi.model;

import ar.com.sdd.commons.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Product
implements Serializable {
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="value")
    private Integer value;
    @JsonProperty(value="quantity")
    private Integer quantity;
    @JsonProperty(value="product_type")
    private String productType;
    @JsonProperty(value="description")
    private String description;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getValue() {
        return this.value;
    }

    @JsonIgnore
    public BigDecimal getValueAsBigDecimal() {
        return this.value != null ? NumberUtil.divideToBigDecimal((BigDecimal)new BigDecimal(this.value), (BigDecimal)NumberUtil.CIEN_SCALED) : null;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @JsonIgnore
    public void setValue(BigDecimal value) {
        this.value = NumberUtil.multiplyToBigDecimal((BigDecimal)value, (BigDecimal)NumberUtil.CIEN_SCALED).intValue();
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Product [" + (String)(this.title != null ? "title='" + this.title + "', " : "") + (String)(this.value != null ? "value=" + this.value + ", " : "") + (String)(this.quantity != null ? "quantity=" + this.quantity + ", " : "") + (String)(this.productType != null ? "productType='" + this.productType + "', " : "") + (String)(this.description != null ? "description='" + this.description + "', " : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return Objects.equals(this.title, product.title) && Objects.equals(this.value, product.value) && Objects.equals(this.quantity, product.quantity) && Objects.equals(this.productType, product.productType) && Objects.equals(this.description, product.description);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.value, this.quantity, this.productType, this.description);
    }
}

