package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicPaymentLink implements Serializable {

    private String actionUrl;
    private String trackingNumber;
    private String orderNumber;
    private Long expiresIn;

    public GicPaymentLink(String actionUrl, String trackingNumber, String orderNumber, Long expiresIn) {
        this.actionUrl = actionUrl;
        this.trackingNumber = trackingNumber;
        this.orderNumber = orderNumber;
        this.expiresIn = expiresIn;
    }

    public String getActionUrl() {
        return actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Long getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "GicPaymentLink [" +
                ((actionUrl != null) ? "actionUrl='" + actionUrl + "', " : "") +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((expiresIn != null) ? "expiresIn=" + expiresIn + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicPaymentLink that = (GicPaymentLink) o;
        return Objects.equals(actionUrl, that.actionUrl) && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(orderNumber, that.orderNumber) && Objects.equals(expiresIn, that.expiresIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(actionUrl, trackingNumber, orderNumber, expiresIn);
    }
}