package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicPaymentStatusInfo implements Serializable {

    private String orderNumber;
    private String ownerDocRef;
    private String legalDocRef;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate;
    private String status;
    private String comments;
    private BigDecimal dueAmount;

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    @Override
    public String toString() {
        return "GicPaymentOrderStatusInfo [" +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((creditDate != null) ? "creditDate=" + creditDate + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicPaymentStatusInfo that = (GicPaymentStatusInfo) o;
        return Objects.equals(orderNumber, that.orderNumber) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(dueDate, that.dueDate) && Objects.equals(creditDate, that.creditDate) && Objects.equals(status, that.status) && Objects.equals(comments, that.comments) && Objects.equals(dueAmount, that.dueAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderNumber, ownerDocRef, legalDocRef, dueDate, creditDate, status, comments, dueAmount);
    }
}