package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicWithholdingCode implements Serializable {

    private String id;
    private String description;
    private String account;
    private String region;

    public GicWithholdingCode(String id, String description, String account, String region) {
        this.id = id;
        this.description = description;
        this.account = account;
        this.region = region;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public String toString() {
        return "GicWithholdingCode [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((account != null) ? "account='" + account + "', " : "") +
                ((region != null) ? "region='" + region + "'" : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicWithholdingCode that = (GicWithholdingCode) o;
        return Objects.equals(id, that.id) && Objects.equals(description, that.description) && Objects.equals(account, that.account) && Objects.equals(region, that.region);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, description, account, region);
    }
}