/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.gicapi.client.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.DateUtil;
import ar.com.sdd.gicapi.client.core.GicPadApiConnectorContext;
import ar.com.sdd.gicapi.client.io.CommonError;
import java.util.Date;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GicPadApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(GicPadApiConnector.class);
    private final RestConnector restConnector;
    private final String ocpApimSubscriptionKey;

    public GicPadApiConnector(GicPadApiConnectorContext context) {
        this.ocpApimSubscriptionKey = context.getOcpApimSubscriptionKey();
        log.debug("Creando GicPadApiConnector con {}", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public String getFacturasGic(Date baseDate, Integer searchBy) throws RestConnectorException {
        String paramFecha = "";
        if (baseDate != null) {
            if (searchBy == null || searchBy == 5) {
                paramFecha = DateUtil.format((Date)baseDate, (String)"yyyy-MM-dd");
            } else if (searchBy == 2) {
                paramFecha = DateUtil.format((Date)baseDate, (String)"yyyy-MM");
            } else if (searchBy == 1) {
                paramFecha = DateUtil.format((Date)baseDate, (String)"yyyy");
            }
        }
        String path = "/GIC/GetFacturasGic?fecha=" + paramFecha;
        log.debug("[getFacturasGic] Request GET obtener Facturas con path [{}]", (Object)path);
        return (String)this.restConnector.genericGet(null, String.class, CommonError.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Ocp-Apim-Subscription-Key", (Object)this.ocpApimSubscriptionKey);
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

