package ar.com.sdd.gicapi.client.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.DateUtil;
import ar.com.sdd.gicapi.client.io.CommonError;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;
import java.util.Calendar;
import java.util.Date;

@SuppressWarnings("unused")
public class GicPadApiConnector implements RestSecurityManager {

    private final static Logger log = LogManager.getLogger(GicPadApiConnector.class);

    private final RestConnector restConnector;
    private final String ocpApimSubscriptionKey;

    public GicPadApiConnector(GicPadApiConnectorContext context) {
        this.ocpApimSubscriptionKey = context.getOcpApimSubscriptionKey();

        log.debug("Creando GicPadApiConnector con {}", context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        restConnector = new RestConnector(environment, this);
    }

    /**
     * Devuelve el conjunto de Facturas que fueron pagadas, junto con el detalle de c&oacute;mo fueron pagadas
     *
     * @param baseDate Fecha a partir de la cual se realizar&aacute; la b&uacute;squeda de Facturas
     * @param searchBy Formato de busqueda. Usar como valores {@link Calendar#DATE} o null|{@link Calendar#MONTH}|{@link Calendar#YEAR}
     */
    public String getFacturasGic(Date baseDate, Integer searchBy) throws RestConnectorException {
        String paramFecha = "";
        if (baseDate != null) {
            if (searchBy == null || searchBy == Calendar.DATE) {
                paramFecha = DateUtil.format(baseDate, "yyyy-MM-dd");
            } else if (searchBy == Calendar.MONTH) {
                paramFecha = DateUtil.format(baseDate, "yyyy-MM");
            } else if (searchBy == Calendar.YEAR) {
                paramFecha = DateUtil.format(baseDate, "yyyy");
            }
        }
        String path = "/GIC/GetFacturasGic?fecha=" + paramFecha;
        log.debug("[getFacturasGic] Request GET obtener Facturas con path [{}]", path);
        return restConnector.genericGet(null, String.class, CommonError.class, path);
    }

    @SuppressWarnings("RedundantThrows")
    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Ocp-Apim-Subscription-Key", ocpApimSubscriptionKey);
        }
        return builder;
    }

    @Override
    public boolean retryOnUnauthorized() {
        return false;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}