package ar.com.sdd.gicapi.client.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class PaymentStatusUpdateRequest implements Serializable {

    @JsonProperty("trackingNumber")
    private String trackingNumber;

    @JsonProperty("newState")
    private String newState;

    public PaymentStatusUpdateRequest(String trackingNumber, String newState) {
        this.trackingNumber = trackingNumber;
        this.newState = newState;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getNewState() {
        return newState;
    }

    public void setNewState(String newState) {
        this.newState = newState;
    }

    @Override
    public String toString() {
        return "PaymentStatusUpdateRequest [" +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((newState != null) ? "newState='" + newState + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentStatusUpdateRequest that = (PaymentStatusUpdateRequest) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(newState, that.newState);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, newState);
    }
}