package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicDocument implements Serializable {
    //Datos recibidos en publicacion
    private String type;
    private String ownerType;
    private String ownerCode;
    private String payerCuit;
    private String payerCode;
    private String shipToCode;
    private String ownerDocRef;
    private String legalDocRef;
    private String operatorEmail;
    private String operatorName;
    private String currency;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private BigDecimal dueAmount2;
    private BigDecimal financialDiscount1;
    private String comments;
    private String accountCode;
    private String accountDescription;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate2;
    private String assignmentNumber;
    private String division;
    //Para devolver info
    private String status;
    private String orderNumber;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate;
    private String collectorBank;
    private String issuerBank;
    private String installmentPlan;
    private String attachment;
    private String attachmentName;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerCode() {
        return ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getShipToCode() {
        return shipToCode;
    }

    public void setShipToCode(String shipToCode) {
        this.shipToCode = shipToCode;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getOperatorEmail() {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.operatorEmail = operatorEmail;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public BigDecimal getDueAmount2() {
        return dueAmount2;
    }

    public void setDueAmount2(BigDecimal dueAmount2) {
        this.dueAmount2 = dueAmount2;
    }

    public BigDecimal getFinancialDiscount1() {
        return financialDiscount1;
    }

    public void setFinancialDiscount1(BigDecimal financialDiscount1) {
        this.financialDiscount1 = financialDiscount1;
    }

    public Date getDueDate2() {
        return dueDate2;
    }

    public void setDueDate2(Date dueDate2) {
        this.dueDate2 = dueDate2;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public String getAccountDescription() {
        return accountDescription;
    }

    public void setAccountDescription(String accountDescription) {
        this.accountDescription = accountDescription;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getAssignmentNumber() {
        return assignmentNumber;
    }

    public void setAssignmentNumber(String assignmentNumber) {
        this.assignmentNumber = assignmentNumber;
    }


    public String getDivision() {
        return division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public String getCollectorBank() {
        return collectorBank;
    }

    public void setCollectorBank(String collectorBank) {
        this.collectorBank = collectorBank;
    }

    public String getIssuerBank() {
        return issuerBank;
    }

    public void setIssuerBank(String issuerBank) {
        this.issuerBank = issuerBank;
    }

    public String getInstallmentPlan() {
        return installmentPlan;
    }

    public void setInstallmentPlan(String installmentPlan) {
        this.installmentPlan = installmentPlan;
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public String getAttachmentName() {
        return attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    @Override
    public String toString() {
        return "GicDocument [" +
                ((type != null) ? "type='" + type + "', " : "") +
                ((ownerType != null) ? "ownerType='" + ownerType + "', " : "") +
                ((ownerCode != null) ? "ownerCode='" + ownerCode + "', " : "") +
                ((payerCuit != null) ? "payerCuit='" + payerCuit + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((shipToCode != null) ? "shipToCode='" + shipToCode + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((operatorEmail != null) ? "operatorEmail='" + operatorEmail + "', " : "") +
                ((operatorName != null) ? "operatorName='" + operatorName + "', " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "") +
                ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "") +
                ((dueAmount2 != null) ? "dueAmount2=" + dueAmount2 + ", " : "") +
                ((financialDiscount1 != null) ? "financialDiscount1=" + financialDiscount1 + ", " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((accountCode != null) ? "accountCode='" + accountCode + "', " : "") +
                ((accountDescription != null) ? "accountDescription='" + accountDescription + "', " : "") +
                ((issueDate != null) ? "issueDate=" + issueDate + ", " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((dueDate2 != null) ? "dueDate2=" + dueDate2 + ", " : "") +
                ((assignmentNumber != null) ? "assignmentNumber='" + assignmentNumber + "', " : "") +
                ((division != null) ? "division='" + division + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((creditDate != null) ? "creditDate=" + creditDate + ", " : "") +
                ((collectorBank != null) ? "collectorBank='" + collectorBank + "', " : "") +
                ((issuerBank != null) ? "issuerBank='" + issuerBank + "', " : "") +
                ((installmentPlan != null) ? "installmentPlan='" + installmentPlan + "', " : "") +
                ((attachment != null) ? "attachment='" + attachment + "', " : "") +
                ((attachmentName != null) ? "attachmentName='" + attachmentName + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicDocument that = (GicDocument) o;
        return Objects.equals(type, that.type) && Objects.equals(ownerType, that.ownerType) && Objects.equals(ownerCode, that.ownerCode) && Objects.equals(payerCuit, that.payerCuit) && Objects.equals(payerCode, that.payerCode) && Objects.equals(shipToCode, that.shipToCode) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(operatorEmail, that.operatorEmail) && Objects.equals(operatorName, that.operatorName) && Objects.equals(currency, that.currency) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(dueAmount, that.dueAmount) && Objects.equals(dueAmount2, that.dueAmount2) && Objects.equals(financialDiscount1, that.financialDiscount1) && Objects.equals(comments, that.comments) && Objects.equals(accountCode, that.accountCode) && Objects.equals(accountDescription, that.accountDescription) && Objects.equals(issueDate, that.issueDate) && Objects.equals(dueDate, that.dueDate) && Objects.equals(dueDate2, that.dueDate2) && Objects.equals(assignmentNumber, that.assignmentNumber) && Objects.equals(division, that.division) && Objects.equals(status, that.status) && Objects.equals(orderNumber, that.orderNumber) && Objects.equals(creditDate, that.creditDate) && Objects.equals(collectorBank, that.collectorBank) && Objects.equals(issuerBank, that.issuerBank) && Objects.equals(installmentPlan, that.installmentPlan) && Objects.equals(attachment, that.attachment) && Objects.equals(attachmentName, that.attachmentName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, ownerType, ownerCode, payerCuit, payerCode, shipToCode, ownerDocRef, legalDocRef, operatorEmail, operatorName, currency, totalAmount, dueAmount, dueAmount2, financialDiscount1, comments, accountCode, accountDescription, issueDate, dueDate, dueDate2, assignmentNumber, division, status, orderNumber, creditDate, collectorBank, issuerBank, installmentPlan, attachment, attachmentName);
    }
}