package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicDocumentSet implements Serializable {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate = null;
    private String trackingNumber = "";
    private String channel = "";
    private List<String> paymentMethod;
    private List<String> paymentMethodSubtype;
    private List<GicDocument> documents;
    private String urlBack;

    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public List<String> getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(List<String> paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public List<String> getPaymentMethodSubtype() {
        return paymentMethodSubtype;
    }

    public void setPaymentMethodSubtype(List<String> paymentMethodSubtype) {
        this.paymentMethodSubtype = paymentMethodSubtype;
    }

    public List<GicDocument> getDocuments() {
        return documents;
    }

    public void setDocuments(List<GicDocument> documents) {
        this.documents = documents;
    }

    public String getUrlBack() {
        return urlBack;
    }

    public void setUrlBack(String urlBack) {
        this.urlBack = urlBack;
    }

    @Override
    public String toString() {
        return "GicDocumentSet [" +
                ((processDate != null) ? "processDate=" + processDate + ", " : "") +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((channel != null) ? "channel='" + channel + "', " : "") +
                ((paymentMethod != null) ? "paymentMethod=" + Arrays.toString(paymentMethod.toArray()) + ", " : "") +
                ((paymentMethodSubtype != null) ? "paymentMethodSubtype=" + Arrays.toString(paymentMethodSubtype.toArray()) + ", " : "") +
                ((documents != null) ? "documents=" + Arrays.toString(documents.toArray()) + ", " : "") +
                ((urlBack != null) ? "urlBack='" + urlBack + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicDocumentSet that = (GicDocumentSet) o;
        return Objects.equals(processDate, that.processDate) && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(channel, that.channel) && Objects.equals(paymentMethod, that.paymentMethod) && Objects.equals(paymentMethodSubtype, that.paymentMethodSubtype) && Objects.equals(documents, that.documents) && Objects.equals(urlBack, that.urlBack);
    }

    @Override
    public int hashCode() {
        return Objects.hash(processDate, trackingNumber, channel, paymentMethod, paymentMethodSubtype, documents, urlBack);
    }
}