package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicPayment implements Serializable {

    private String type;
    private String paymentTerms;
    private String legalDocRef;
    private String ownerDocRef;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creationDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'", timezone = "GMT+00:00")
    private Date creationTimestampUtc;
    private BigDecimal exchangeRate;
    private String status;
    private List<GicDocument> documents; //Payables
    private List<GicDocument> deductions;
    private List<GicDocument> instruments; //RPG+SETT

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPaymentTerms() {
        return paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationTimestampUtc() {
        return creationTimestampUtc;
    }

    public void setCreationTimestampUtc(Date creationTimestampUtc) {
        this.creationTimestampUtc = creationTimestampUtc;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<GicDocument> getDocuments() {
        return documents;
    }

    public void setDocuments(List<GicDocument> documents) {
        this.documents = documents;
    }

    public List<GicDocument> getDeductions() {
        return deductions;
    }

    public void setDeductions(List<GicDocument> deductions) {
        this.deductions = deductions;
    }

    public List<GicDocument> getInstruments() {
        return instruments;
    }

    public void setInstruments(List<GicDocument> instruments) {
        this.instruments = instruments;
    }

    @Override
    public String toString() {
        return "GicPayment [" +
                ((type != null) ? "type='" + type + "', " : "") +
                ((paymentTerms != null) ? "paymentTerms='" + paymentTerms + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((creationDate != null) ? "creationDate=" + creationDate + ", " : "") +
                ((creationTimestampUtc != null) ? "creationTimestampUtc=" + creationTimestampUtc + ", " : "") +
                ((exchangeRate != null) ? "exchangeRate=" + exchangeRate + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((documents != null) ? "documents=" + Arrays.toString(documents.toArray()) + ", " : "") +
                ((deductions != null) ? "deductions=" + Arrays.toString(deductions.toArray()) + ", " : "") +
                ((instruments != null) ? "instruments=" + Arrays.toString(instruments.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicPayment that = (GicPayment) o;
        return Objects.equals(type, that.type) && Objects.equals(paymentTerms, that.paymentTerms) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(creationDate, that.creationDate) && Objects.equals(creationTimestampUtc, that.creationTimestampUtc) && Objects.equals(exchangeRate, that.exchangeRate) && Objects.equals(status, that.status) && Objects.equals(documents, that.documents) && Objects.equals(deductions, that.deductions) && Objects.equals(instruments, that.instruments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, paymentTerms, legalDocRef, ownerDocRef, creationDate, creationTimestampUtc, exchangeRate, status, documents, deductions, instruments);
    }
}