/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.gicapi.client.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.gicapi.client.core.GicApiConnectorContext;
import ar.com.sdd.gicapi.client.io.GicOAuth2Credential;
import ar.com.sdd.gicapi.client.io.GicTokenOAuth2;
import ar.com.sdd.gicapi.client.io.PaymentStatusUpdateRequest;
import ar.com.sdd.gicapi.client.io.PaymentStatusUpdateResponse;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GicApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(GicApiConnector.class);
    private final RestConnector restConnector;
    private final String clientId;
    private final String clientSecret;
    private boolean doingLogin;
    private final String origen;

    public GicApiConnector(GicApiConnectorContext context) {
        this.origen = context.getOrigen();
        this.clientId = context.getClientId();
        this.clientSecret = context.getClientSecret();
        log.trace("Creando GicApiConnector con {}", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public PaymentStatusUpdateResponse postPaymentStatusUpdate(PaymentStatusUpdateRequest paymentStatusUpdateRequest) throws RestConnectorException {
        String path = "/Payment/paymentStatusUpdate/" + this.origen;
        log.debug("[postPaymentStatusUpdate] Por notificar cambio de estado de un pago con path [{}] y {}", (Object)path, (Object)paymentStatusUpdateRequest);
        return (PaymentStatusUpdateResponse)this.restConnector.genericPost((Object)paymentStatusUpdateRequest, PaymentStatusUpdateResponse.class, PaymentStatusUpdateResponse.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null && !this.doingLogin) {
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken(false)));
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        try {
            this.getAccessToken(true);
            return true;
        }
        catch (Exception any) {
            return false;
        }
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(GicApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            log.debug("[getAccessToken] Por recuperar token con clientId [{}] y clientSecret [{}]", (Object)this.clientId, (Object)this.clientSecret);
            this.doingLogin = true;
            GicTokenOAuth2 tokenOAuth2Response = (GicTokenOAuth2)this.restConnector.genericPost((Object)new GicOAuth2Credential(this.clientId, this.clientSecret, "GIC_credentials"), GicTokenOAuth2.class, "/Auth/generateToken/" + this.origen);
            this.doingLogin = false;
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}] segs. Lo agrego al a cache", (Object)tokenOAuth2Response, (Object)tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getToken();
            cache.put(cacheKey, (Object)accessToken, tokenOAuth2Response.getExpiresIn());
        }
        return accessToken;
    }
}

