package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicDocument implements Serializable {
    //Datos recibidos en publicacion
    private String ownerType;
    private String ownerCode;
    private String payerCuit;
    private String payerCode;
    private String shiptoCode;
    private String ownerDocRef;
    private String legalDocRef;
    private String operatorEmail;
    private String operatorName;
    private String currency;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private BigDecimal dueAmount2;
    private String comments;
    private String accountCode;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate2;
    private String assignmentNumber;
    private String division;
    //Para devolver info
    private String status;
    private String orderNumber;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate;
    private String collectorBank;
    private String issuerBank;
    private String installmentPlan;

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerCode() {
        return ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getShiptoCode() {
        return shiptoCode;
    }

    public void setShiptoCode(String shiptoCode) {
        this.shiptoCode = shiptoCode;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getOperatorEmail() {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.operatorEmail = operatorEmail;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public BigDecimal getDueAmount2() {
        return dueAmount2;
    }

    public void setDueAmount2(BigDecimal dueAmount2) {
        this.dueAmount2 = dueAmount2;
    }

    public Date getDueDate2() {
        return dueDate2;
    }

    public void setDueDate2(Date dueDate2) {
        this.dueDate2 = dueDate2;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getAssignmentNumber() {
        return assignmentNumber;
    }

    public void setAssignmentNumber(String assignmentNumber) {
        this.assignmentNumber = assignmentNumber;
    }


    public String getDivision() {
        return division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public String getCollectorBank() {
        return collectorBank;
    }

    public void setCollectorBank(String collectorBank) {
        this.collectorBank = collectorBank;
    }

    public String getIssuerBank() {
        return issuerBank;
    }

    public void setIssuerBank(String issuerBank) {
        this.issuerBank = issuerBank;
    }

    public String getInstallmentPlan() {
        return installmentPlan;
    }

    public void setInstallmentPlan(String installmentPlan) {
        this.installmentPlan = installmentPlan;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicDocument that = (GicDocument) o;
        return Objects.equals(ownerType, that.ownerType) && Objects.equals(ownerCode, that.ownerCode) && Objects.equals(payerCuit, that.payerCuit) && Objects.equals(payerCode, that.payerCode) && Objects.equals(shiptoCode, that.shiptoCode) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(operatorEmail, that.operatorEmail) && Objects.equals(operatorName, that.operatorName) && Objects.equals(currency, that.currency) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(dueAmount, that.dueAmount) && Objects.equals(dueAmount2, that.dueAmount2) && Objects.equals(comments, that.comments) && Objects.equals(accountCode, that.accountCode) && Objects.equals(issueDate, that.issueDate) && Objects.equals(dueDate, that.dueDate) && Objects.equals(dueDate2, that.dueDate2) && Objects.equals(assignmentNumber, that.assignmentNumber) && Objects.equals(division, that.division) && Objects.equals(status, that.status) && Objects.equals(orderNumber, that.orderNumber) && Objects.equals(creditDate, that.creditDate) && Objects.equals(collectorBank, that.collectorBank) && Objects.equals(issuerBank, that.issuerBank) && Objects.equals(installmentPlan, that.installmentPlan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ownerType, ownerCode, payerCuit, payerCode, shiptoCode, ownerDocRef, legalDocRef, operatorEmail, operatorName, currency, totalAmount, dueAmount, dueAmount2, comments, accountCode, issueDate, dueDate, dueDate2, assignmentNumber, division, status, orderNumber, creditDate, collectorBank, issuerBank, installmentPlan);
    }

    @Override
    public String toString() {
        return "GicDocument [" +
                ((ownerType != null) ? "ownerType='" + ownerType + "', " : "") +
                ((ownerCode != null) ? "ownerCode='" + ownerCode + "', " : "") +
                ((payerCuit != null) ? "payerCuit='" + payerCuit + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((shiptoCode != null) ? "shiptoCode='" + shiptoCode + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((operatorEmail != null) ? "operatorEmail='" + operatorEmail + "', " : "") +
                ((operatorName != null) ? "operatorName='" + operatorName + "', " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "") +
                ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "") +
                ((dueAmount2 != null) ? "dueAmount2=" + dueAmount2 + ", " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((accountCode != null) ? "accountCode='" + accountCode + "', " : "") +
                ((issueDate != null) ? "issueDate=" + issueDate + ", " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((dueDate2 != null) ? "dueDate2=" + dueDate2 + ", " : "") +
                ((assignmentNumber != null) ? "assignmentNumber='" + assignmentNumber + "', " : "") +
                ((division != null) ? "division='" + division + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((creditDate != null) ? "creditDate=" + creditDate + ", " : "") +
                ((collectorBank != null) ? "collectorBank='" + collectorBank + "', " : "") +
                ((issuerBank != null) ? "issuerBank='" + issuerBank + "', " : "") +
                ((installmentPlan != null) ? "installmentPlan='" + installmentPlan + "', " : "") +
                "]";
    }
}
