package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicDocumentSet implements Serializable {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date   processDate = null;
    private String trackingNumber = "";
    private String channel = "";
    private String paymentMethod = "";

    private List<GicDocument> documents = null;

    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public List<GicDocument> getDocuments() {
        return documents;
    }

    public void setDocuments(List<GicDocument> documents) {
        this.documents = documents;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicDocumentSet that = (GicDocumentSet) o;
        return Objects.equals(processDate, that.processDate) && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(documents, that.documents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(processDate, trackingNumber, channel,documents);
    }

    @Override
    public String toString() {
        return "GicDocumentSet [" +
                ((processDate != null) ? "processDate=" + processDate + ", " : "") +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((channel != null) ? "channel='" + channel + "', " : "") +
                ((documents != null) ? "documents=" + Arrays.toString(documents.toArray()) + ", " : "") +
                "]";
    }
}
